@extends('frontend.layouts._layout')
@section('content')
    <!-- info buttons -->
    <!-- info buttons -->
@include('frontend.partials.info-container')
    <!-- info boxes -->
@include('frontend.partials.info-box-container')

    <section class="main-blog-content">
        <p>At Grameen Kalyan, we prioritize treating the patients for their well-being instead of just the disease. The relationship between the health professionals and patients at Kalyan is based upon trust and reliance and the treatment relies on in-depth communication and competence. And when quality care satisfies the patient’s requirements, Kalyan’s vision of an improved lifestyle for the marginalized is achieved.   </p>
        <p>Early detection of both acute and chronic diseases can increase the likelihood of survival and allow Kalyan medical professionals to manage it accordingly at the health centers. Through Kalyan’s doctor’s consultation, the patient receives an extensive diagnosis of all the symptoms, and the previous medical conditions are reassessed for the best possible Medicare solution for the patient. The patients trust their doctors to be respectful towards them and feel at ease thus being more likely to follow the treatment with successful consultation.  </p>
        <p>As a primary healthcare giver, Kalyan’s doctors focus and respond to the patients’ discomfort, pain, and other disabilities during their diagnosis. The patients are given detailed information about the diagnosis to convey their concerns to the doctor at length, such as the reason behind the complications or how it will affect the family members physically and financially, etc.    </p>
        <p>Doctor consultation often does not take special preparation; instead, it is a simple procedure for doctors and patients. During the consultation, the physicians perform a systematic medical review by asking multiple questions covering general condition, patient symptoms, health concerns and previous medical history.  </p>
        <p>The patients have to go through physical exams depending on the problem they came to get consultation on. The patients are ushered to appropriate doctors based on the information, such as a patient not seeing properly has to undergo a vision test done by an optometrist or ophthalmic assistant.  </p>
        <p class="headline">500,000+ People served with consultation</p>
        <p class="headline">BDT 35,527,000+ In Revenue from Consultation </p>
        <p>Kalyan health professionals try to implement necessary preventive measures to end the development of various health complications in patients, especially those with risk factors. With experienced doctors and health workers, proper diagnosis and doctor consultation significantly impact the treatment of people across the country. </p>
    </section>

    <section class="main-blog-content-footer">
        <a href="/healthcare">back</a>
    </section>

@endsection
@section('scripts')
<link rel="stylesheet" href="/css/scss/service-special.css">

    <script src="https://cdn.jsdelivr.net/gh/dixonandmoe/rellax@master/rellax.min.js"></script>
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <!-- <script src="/js/index.js"></script> -->
    <!-- <script src="/js/counter.js"></script> -->
    <!-- <script src="/js/index-image-hover.js"></script> -->
    <!-- <script src="/js/dropdown.js"></script> -->
    <script src="/js/slick.min.js"></script>
    <script src="/js/custom-slick.js"></script>

@endsection
