@extends('frontend.layouts._layout')
@section('content')
   <!-- info buttons -->
@include('frontend.partials.info-container')
    <!-- info boxes -->
@include('frontend.partials.info-box-container')
    <!-- health care grid -->
    <section class="health-grid-section">
        <!-- leaf collections -->
        <div class="grid-top-left">
            <img src="/assets/healthcare/grid-leaf/grid-top-leaf.png" alt="">
        </div>
        <div class="grid-bottom-right">
            <img src="/assets/healthcare/grid-leaf/grid-bottom-leaf.png" alt="">
        </div>
        <div class="health-grid-container">
            <div class="health-grid-list">
                <div class="grid-item grid-item-left grid-item-first">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                        <a href="/micro-health-insurance"><img src="/assets/healthcare/grid/grid-1.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>micro health insurance</h3>
                    </div>
                    <div class="green-box-container">
                        <div class="green-box"></div>
                    </div>
                </div>
                <div class="grid-item grid-item-right">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/doctor-consulation"><img src="/assets/healthcare/grid/grid-2.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Doctor Consultation</h3>
                    </div>
                </div>
                <div class="grid-item grid-item-left grid-item-third">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/primary-diagnosis"><img src="/assets/healthcare/grid/grid-3.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Primary Diagnosis</h3>
                    </div>
                    <div class="green-box-container">
                        <div class="green-box"></div>
                    </div>
                </div>
                <div class="grid-item grid-item-right">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/door-to-door-visit"><img src="/assets/healthcare/grid/grid-4.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Door to Door Visit</h3>
                    </div>
                </div>
                <div class="grid-item grid-item-left grid-item-fifth">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/health-camps"><img src="/assets/healthcare/grid/grid-5.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Health Camps</h3>
                    </div>
                    <div class="green-box-container">
                        <div class="green-box"></div>
                    </div>
                </div>
                <div class="grid-item grid-item-right">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/digital-healthcare"><img src="/assets/healthcare/grid/grid-6.jpg" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Digital Healthcare</h3>
                    </div>
                </div>
                <div class="grid-item grid-item-left grid-item-seventh">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/vaccination-immunisation"><img src="/assets/healthcare/grid/grid-7.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Vaccination & Immunisation</h3>
                    </div>
                    <div class="green-box-container">
                        <div class="green-box"></div>
                    </div>
                </div>
                <div class="grid-item grid-item-right">
                    <div class="grid-image" data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">
                    <a href="/access-to-medicine"><img src="/assets/healthcare/grid/grid-8.webp" alt=""></a>
                    </div>
                    <div class="grid-content">
                        <h3>Access to Medicine</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-health-center-header">
        <h2>our health centers</h2>
    </section>
    <section class="health-center-location" id="findHealthCenter">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-12 p-4 bangladesh-map">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 741.706 1002.594">
                    <g id="Group_134" data-name="Group 134" transform="translate(881.271 -197.762)">
                        <g id="Group_132" data-name="Group 132" transform="translate(-1005.942 -31.583)" class="barisal-division">
                            <path id="Path_414" data-name="Path 414" d="M607.158,4546.67q.108-1.952.216-3.9l.093-.968q.023-1.452.047-2.9a37,37,0,0,0-1.542-16.51c-1.374-4.149-2.794-8.284-4.037-12.472-.642-2.163-.873-4.626,2.582-4.036a92.166,92.166,0,0,0,12.109.861c1.2.046,2.308.264,2.793,1.508,1.63,4.18,4.444,7.866,4.808,12.587.295,3.851.9,7.689,3.929,10.626,1.614,1.564,1.8,3.615,1.807,5.833.032,7.837-2.525,15.316-2.994,23.071q-.473,1-.944,1.989c-3.84,1.868-7.407,4.079-9.811,7.76l.014-.009-5.287,4.923c-1.385,1.291-2.883,1.124-4.495.45-1.873-.785-1.3-2.148-1.192-3.631.462-6.428.755-12.87,1.11-19.306q.114-1.929.226-3.858A1.723,1.723,0,0,0,607.158,4546.67Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_425" data-name="Path 425" d="M595.228,4530.97c-.882-1.256-2.555-1.132-3.548.547-.731,1.236-1.544,2.423-2.321,3.632-.268,6.861-4.589,12.644-5.165,19.424q-.052,2.413-.108,4.823.009,2.92.017,5.841c.026,1.673.137,3.319,1.44,4.592a11.965,11.965,0,0,1,5.341,5.182,2.724,2.724,0,0,0,3.645,1.462c1.564-.637.978-2.2,1.075-3.413.525-6.523-1.166-13.153.951-19.6.072-1.645.286-3.218,2.027-4.022q.342-.478.686-.956c.618-1.883-.16-4.027,1.076-5.8q.143-1.422.288-2.847.223-1.052.443-2.106C600.093,4534.66,596.966,4533.44,595.228,4530.97Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_426" data-name="Path 426" d="M530.408,4569.9c.143-7.732,3.02-13.355,5.263-19.082,1.863-4.756,5.063-9,4.549-14.556-.239-2.587,1.845-3.973,4.057-3.865,2.421.118,1.349,2.519,1.521,3.926C547.473,4549.97,541.542,4560.3,530.408,4569.9ZM493.7,4598.56c-1.972-6.278,1.122-10,6.081-13.848a55.586,55.586,0,0,1-6.081,13.848Zm86.346-93.78a43.735,43.735,0,0,1-8.846-10.824c-1.782-1.822-3.987-3.29-4.873-5.857a1.774,1.774,0,0,1-.723-1.993l-1.056-3.9a3.564,3.564,0,0,1-.729-2.957q-1.161-4.377-2.327-8.756a1.782,1.782,0,0,1-.782-1.982c-.476-1.7-.909-3.417-1.441-5.1-.571-1.805-.9-3.918-3.6-3.643-2.878.214-5.661,1.478-8.705.715-.039-1.446,1.447-1.3,2.155-1.938,4.9-4.445,4.743-10.48-.375-16.1-1.388-1.524-3.424-2.512-4.018-4.716-1.936-.689-4.073-.88-5.72-2.293l-1.985-.885-1.889-.331-1.193-.78-2.7-1.1a1.869,1.869,0,0,1-1.958-.931l-1.923-1.251c-4.743-3.615-9.444-7.3-15.425-8.736-5.453.48-10.247,2.187-13.857,6.66-2.156,2.671-19.66,1.858-21.713-.9-1.711-2.3-.419-5.055-.833-7.563-.317-1.923,1.3-4.947-1.431-5.5-2.547-.512-6.514-.037-7.533,2.19-1.717,3.754-4.975,5.282-7.782,7.338-4.3,3.148-6.371,8.027-10.057,11.558-1.6,1.535-1.652,3.525-2.055,5.344-1.093,4.939-3.632,7.834-9.018,7.448a6.145,6.145,0,0,0-4.146,1.14c.9,3.417,1.9,6.809,2.661,10.257,1.341,6.115-.31,8.953-6.368,11.015-1.247.424-2.9.458-2.679,2.138.257,1.92,1.789,1.659,3.4,1.484,3.717-.4,5.948,1.483,5.878,5.234a32.642,32.642,0,0,0,1.83,10.947c1.058,3.218,1.81,6.56.339,9.972a7.18,7.18,0,0,0-.13,2.9c.043,1.327-1.8,11.909-2.352,12.83-.33.546-.707,1.294-1.223,1.464-6.038,1.98-5.29,7.025-5.189,11.636.073,3.384-.538,6.09-3.123,8.714-4.731,4.8-5.1,15.358-1.288,20.737,3.083,4.349,3.283,14.259.355,17.618-.495,8.226,3.03,15.011,7.5,21.533,1.268,1.848,2.863,2.845,4.283,1.224,3.7-4.227,6.789-.826,11.07.18a14.215,14.215,0,0,1-2.884,1.41c-5.014.8-5.575,3.722-4.528,8.117.971,4.081,4.51,7.584,2.624,12.429-.487,1.249,1.651,1.535,2.885,1.936,3.489,1.132,7.6.579,10.42,3.5,4.784,4.961,10.392,5.333,16.523,3.284,1.92.031,4.128.509,4.02-2.6a3.7,3.7,0,0,1,2.977-1.1c1.4,1.25,2.364,1.014,2.871-.829q1-.11,2-.223a7.038,7.038,0,0,0-.06-2.422c-3.543-8.68,3.754-12.445,7.966-17.676-2.432,6.3-4.6,12.608-4.772,19.418,1.913.664,2.8-1.95,4.561-1.066,4.344-1.841,5.056-5.864,6.094-9.816,1.378-5.251,2.358-5.744,6.937-3.262a5.621,5.621,0,0,0,5.922.149,1.857,1.857,0,0,0,1.637-2.012c.04-1.443,1.356-1.984,2.083-2.941a10.665,10.665,0,0,1,.417-2.832c3.483-7.866,1.436-14.118-6.41-19.563,4.372.674,7.756,1.093,12.015-1.9-3.482,6.821-1.966,12.587-2.246,18.224-.051,1.015-.449,2.637,1.083,2.767a4.24,4.24,0,0,0,2.939-1.4c2.054-2.219,3.442-5.11,6.569-6.19a3.1,3.1,0,0,1,1.979-3.064,1.073,1.073,0,0,1,0-.718c-1.033-3.168-.709-6.56-2.626-9.7-1.173-1.925,3.074-3.657,1.839-7.352,3.9,2.705,6.651,4.553,2.972,8.469-2.807,2.989,1.173,5.692.585,8.63q.23,1.417.461,2.83c4.49,6.96,8.656.085,12.585-.471,3.148,2.352-4.907,7.79,2.884,8.459l1.946-.017,1.958-.042,2.826-.081q.03-.946.059-1.893l-.956-.942a3.213,3.213,0,0,1-2.88-2.993l-.018-.019c-1.281-.685-3.222-2.314-2.633-2.89,2.3-2.247,1.439-6.3,4.584-7.764a42.153,42.153,0,0,1,5.869-1.794c.66-.046,1.32-.094,1.98-.141a2.939,2.939,0,0,1,1.919-2.026l.011-.008c-.237-4.882,2.8-7.217,6.832-8.77l1.079-.974a64.268,64.268,0,0,1,6.429-33.769c1.171-2.381.381-5.727.495-8.629.088-2.248-.2-4.685,2.718-5.544a2.668,2.668,0,0,1,.242-.933c-.176-1.077-.413-2.166.614-2.994v-7.735q-1.5-2.9-3.006-5.787-.4-.509-.808-1Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_428" data-name="Path 428" d="M548.088,4606.29c-2.176-6.529-5.307-7.756-9.974-3.91-2.582,2.932-.744,5.379.862,7.853-.554.386-.915.926-.3,1.425.6.485,1.072,0,1.394-.558q1.448.195,2.9.393l3.939-2.222Q547.5,4607.78,548.088,4606.29Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_430" data-name="Path 430" d="M532.719,4613.11a33.2,33.2,0,0,1-1.5-12.679c-2.834-.831-4.25,1.138-5.954,2.818a37.81,37.81,0,0,1-4.527,3.346c-.377,1.382-.849,2.745-1.112,4.148-.458,2.436-2.878,5.36,1.049,6.967,3.106,1.272,6.59,4.491,9.269-.821.4-.787,1.4-1.267,2.127-1.888.554-.208,1.38-.262,1.6-.655C534.08,4613.61,533.35,4613.31,532.719,4613.11Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                        </g>
                        <g id="Group_131" data-name="Group 131" transform="translate(-1004.42 -34.07)" class="chittagong-division">
                            <path id="Path_415" class="" data-name="Path 415" d="M688.644,4515.41c1.57,5.975.868,11.4-3.1,16.459-2.087,2.664-4.4,3.293-7.519,3.19-2.631-.086-4.441-.4-4.288-3.64.121-2.563-1.415-3.97-3.65-5.184-8.329-4.522-14.34-15.4-11.269-23.548,2.5-6.626,1.092-11.141-2.784-16-1.517-1.9-3.443-4.644-2.141-6.536,1.428-2.075,4.033.761,6.165.761,11,0,13.956,8.586,18.057,16.291,3.04,5.71,6.833,11.016,10.29,16.5C688.484,4514.27,688.565,4514.84,688.644,4515.41Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_416" class="" data-name="Path 416" d="M633.423,4489.93a15.31,15.31,0,0,0,.384-1.9c.645-8.005.81-8.167,8.124-4.533a12.873,12.873,0,0,1,7.66,11.414q-.045.97-.091,1.938c-1.327,1.638-.115,5.617-3.986,4.83a44.452,44.452,0,0,1-10.565-3.2c-2.5-1.216-.2-4.579-1.57-6.647Q633.4,4490.88,633.423,4489.93Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_417" class="" data-name="Path 417" d="M633.628,4464.52c5.033-.286,9.245.74,13.141,4.638,3.282,3.285,2.526,6.248,1.536,9.666-.583,2.015-2.293,1.56-3.628,1.2-7.766-2.092-13.427-7.406-18.918-12.837-1.618-1.6-.258-2.586,1.566-2.65C629.423,4464.47,631.527,4464.52,633.628,4464.52Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_418" class="" data-name="Path 418" d="M646.588,4461.39c5.2,1.679,10.23,1.654,12.058,7.194.541,1.644.963,3.2-.825,4.281a2.909,2.909,0,0,1-4.259-.918C651.389,4468.77,648.529,4466.04,646.588,4461.39Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_419" class="" data-name="Path 419" d="M742.6,4617.43c-1.574,7.093-5.718,14.029-9.82,20.973a1.871,1.871,0,0,1-1.66.608,1.834,1.834,0,0,1-1.291-2.311c1.323-4.593.2-9.383,1.262-14,1-4.313.5-8.164-2.871-11.641-3.469-3.574-3.091-4.26,1.527-5.309,10.151-2.308,12.495-.438,12.778,10.194C742.531,4616.11,742.543,4616.27,742.6,4617.43Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                            <path id="Path_420" class="" data-name="Path 420" d="M865.489,4708.44a22.845,22.845,0,0,1-5.289-15.2c.035-4.016-.995-8.031-1.326-12.066-.548-6.676-3.458-12.822-4.217-19.437-1.4-12.174.918-24.243,1.061-36.372a4.517,4.517,0,0,1,1.162-3.078c4.044-4.7,3.183-10.476,2.136-15.623-2-9.822-5.69-19.261-7.46-29.174-.2-1.1-1.56-2.934.39-3.3,3.489-.649,2.529-3.152,2.779-5.243,1.45-12.052-4.506-22.989-5.134-34.867-.549-10.4-3.638-20.685-5.787-30.984-1.115-5.341,1.946-10.43.16-15.94-2.361-7.285-1.447-15.344-8.639-21.265-4.23-3.482-4.28-10.392-3.008-15.945.767-3.348.7-4.768-2.621-6.345-7.039-3.341-10.722-11.818-9.445-19.47,1.071-6.423,4.412-13.289-2.679-18.622-.394-.3-.333-1.222-.449-1.861-.863-4.788-1.763-9.572-2.563-14.371-.575-3.444.11-6.068,3.485-8.255,2.635-1.708,6.02-4.475,3.6-8.388-2.116-3.419-2.063-6.9-2.241-10.585a12.138,12.138,0,0,0-2.51-6.178c-3.21-4.67-7.689-8.571-7.65-15.2.033-5.606-.414-11.526-2.235-16.753-2.1-6.024-3.666-11.549-.9-17.645,1.464-3.225-1.234-4.647-3.341-5.422s-4.853-1.367-6.329,1.688c-.6,1.239-.809,2.833-2.385,3.415-1.289-.585-1.226-1.9-1.651-2.872-3.007-6.853-8.453-7.908-13.677-2.279-3.514,3.787-7.929,6.6-11.023,10.849-1.635,2.242-3.782,2.484-5.4-.375-1.589-2.819-3.111-5.679-4.8-8.44a5.481,5.481,0,0,0-7.72-1.884c-2.575,1.463-6.043,3.346-5.241,7.4,1.376,6.971,2.044,14.306,4.795,20.723,3.03,7.069-1.118,12.684-1.519,18.973-.081,1.27-1.371,1.322-2.306.9-4.23-1.931-7.15.319-9.936,3.012-7.047,6.811-11.229,15.25-14.334,24.426-1.407,4.158-1.139,7.322,1.11,11.348,4.258,7.624,9.457,15.945-.546,23.528-.211.16-.136.657-.322.9-4.843,6.4-7.836,14.864-17.66,15.729-.86.074-1.7.918-2.455,1.523-3.481,2.786-6.166,2.457-7.87-1.925-.289-.742-.495-1.854-1.494-1.5-2.943,1.039-2.67-1.108-2.4-2.569.572-3.127-1.155-5.3-2.858-7.352-1.284-1.548-2.863-3.168-2.757-5.009.438-7.634-2.444-14.359-5.5-20.962-2.642-5.711-5.539-11.575-13.052-12.242-1.379-.122-3.807-.71-3.8.938.03,4.641-2.689,8.569-2.686,13.19,0,4.916.216,9.581,2.971,13.925.942,1.484.9,3.888-1.3,4.51-2.009.57-3.5-.762-3.327-3.009.2-2.539-1.394-4.29-2.475-6.223-1.631-2.912-2.968-5.9-2.438-9.259,1.675-10.63-2.795-20.18-5.075-30.122a93.468,93.468,0,0,0-13.474-30.88c-2.493-3.773-6.1-7.211-6.647-12.169-.165-1.518-1.345-3.467,1.883-2.795,3.036.631,5.356-.116,4.664-3.9-.533-2.914,2.181-7.982-4.371-7.289a1.8,1.8,0,0,1-2.214-1.356,3.337,3.337,0,0,1,1.308-3.882c.631-.466,1.385-1.222,2.06-.271,3.14,4.419,5.265.065,7.47-1.052,2.544-1.288,2.127-3.866.88-5.97-1.381-2.332-1.068-4.9.46-6.331,2.8-2.618,2.266-5.448,1.023-7.965-1.554-3.149-.579-6.138,1.383-7.517,4.46-3.136,4.069-9.387,8.676-12.146.075-2.4-.265-4.789,1.433-6.973a3.549,3.549,0,0,0-.157-4.561c-3.159-3.222-2.3-7.141-2.33-10.936-.006-.973.421-2.154.014-2.883-2.022-3.613-2.025-6.168,2.831-6.94.428-.069,1.15-1.106,1.028-1.4-1.715-4.084.275-6.9,2.7-9.962,1.188-1.5.511-3.835-1.345-5.15-1.765-1.251-4.1-1.619-5.3.121-4.891,7.063-10.555,5.337-16.531,1.947-3.1,3.476-7.608,2.63-11.486,3.683-3.065.833-6.376.838-7.619,4.829-.556,1.784-2.795,1.169-4.372,1.251-1.907.1-3.757-.168-5.533,1.207-4.216,3.266-4.057,5.759.779,8.066,4.965,2.369,5.273,4.8,3.392,9.838-1.584,4.243-4.131,6.215-8.065,7.953a7.568,7.568,0,0,0-4.481,9.524c.248.881.439,2.429-.009,2.757-5.393,3.936-5.2,11.378-9.973,15.672-.711.641-1.179,1.771-2.263,1.575-5.474-.992-10.789,2.377-16.344.4-2.816-1-4.472.515-4.228,3.466.323,3.9-1.39,6.658-3.832,9.545-1.9,2.242-2.719,5.392-4.019,8.14,1.983,1.825,6.224,1.756,5.28,7.112-4.2-6.046-6.45-1.518-9.132.735l-6.179.148c1.085,6.026-.287,12.5,3.9,17.986,1.548,2.028,2.945,3.664,6.744,3.811-3.612,2.028-.83,6.866-5.443,7.3l-.107.093c-2.269,1.963-5.106,2.394-7.9,2.936l-.4.011-.4-.017c-8.375,3.757-6.365,12.816-9.234,19.293-.758,1.709,1.386,7.32,5.647,9.049,4.7,1.908,7.837,9,6.385,13.854-.224,3.376-2.663,5.26-4.906,7.276l-.234.214c-.177.866-.871.881-1.539.937a39.611,39.611,0,0,0-5.441,12.208c-.767,2.853-1.017,5.443.661,7.91,3.4,4.994,4.03,12,11.324,14.275,1.645.515,2.246,4.375,3.328,6.695a1.678,1.678,0,0,1,.788.115c4.362.446,7.1,2.715,7.673,7.149.512,3.952,4.54,5.239,6.1,8.368l-.007-.025c3.088.869,4.274,3.247,4.77,6.115,1.7,9.831,7.446,18.269,9.632,27.95.285,1.266,1.665,2.338,2.662,3.382a85.938,85.938,0,0,1,10.817,12.971,10.194,10.194,0,0,0,14.867,3.04c2.346-1.689,4.445-3.022,7.478-1.516,5.73,2.847,10.077-1.9,15.092-3.023.191-1.108.366-2.22.578-3.324.361-1.878,3.086-3.184,2.035-5.181-2.787-5.3-5.628-10.634-10.311-14.618-2.212-1.883-12.288-2.042-15.36-.253-.251.147-.366.527-.406.587-2.476-3.9-4.981-7.908-7.544-11.875-1.419-2.2-2.868-4.381-2.893-7.109-.011-1.225-.687-2.819.693-3.562,1.442-.778,2.309.692,3.26,1.5a97.067,97.067,0,0,0,7.408,6.279c5.461,3.768,8.584,3.4,13.271-1.221,1.473-1.451,2.626-2.712,4.893-.961,5.869,4.531,12.714,4.142,19.505,3.2,3.664-.508,7.259-1.853,10.666.8a2.593,2.593,0,0,0,2.763.273c2.569-1.127,4.152-.642,5.059,2.389a4.087,4.087,0,0,0,4.15,2.822c2.336-.3,1.373-2.542,1.593-4,.259-1.723,1.328-2.887,2.774-4.477a16.023,16.023,0,0,0,3.835,5.4c.96.839,2.309,1.958,1.668,3.266-2.245,4.581,1.224,5.921,4.027,7.791,2.56,1.707,5.01,3.578,7.54,5.33a22.618,22.618,0,0,1,9.744,16.042c.136.345.276.691.415,1.037,5.3,8.059,12.824,14.021,17.02,23.558a97.79,97.79,0,0,1,7.489,28.187c.381,3.083,1.152,5.847,4.274,7.677,3.371,1.975,2.844,5.942,3.429,9.194.317,1.757-.026,4.009,1.309,5.068,4.323,3.429,4.818,8.068,5.056,13a10.017,10.017,0,0,0,3.242,6.876c1.587,1.506,2.936,3.346,2.842,5.486-.185,4.242.666,7.549,4.9,9.606,1.939.941,1.085,2.892-.177,4.1a5.44,5.44,0,0,0-1.441,6.262c1.038,2.486-.791,4.013-1.281,5.925-2.29,8.948-4.674,17.881-7.371,26.713-.865,2.83-.46,4.743,1.894,6.192,3.369,2.073,3.191,4.819,1.984,8.014-1.087,2.88-1.825,5.893-2.933,8.764a17.489,17.489,0,0,0-.047,12.845c2.99-.408,6.157.911,9-.931-.063-1.635-1.279-3.872,1.058-4.54,2.656-.759,5.417.124,7.9,1.243.687.311.287,1.482-.355,2.066-5.127,4.651-3.092,9.038.4,13.451a6.51,6.51,0,0,1,.656,2.269l-.022-.012c5.867,3.712,6.807,9.825,7.563,15.917.877,7.068,1.405,14.18,2.24,21.255.385,3.267,3.022,5.333,4.95,7.662,4.552,5.5,9.317,10.819,14.1,16.115a6.73,6.73,0,0,1,2.077,5.22c-.585,8.821,4.482,15.519,9.257,21.894a50.58,50.58,0,0,1,8.262,15.695q.256,1.253.515,2.5c2.016,1.208,3.479,2.8,3.635,5.287h3.908c2.008-8.242-1.8-15.141-5.215-22.083-1.2-2.432-1.9-4.5-.688-7.315,1.618-3.766-.965-7.143-2.223-10.538a20.171,20.171,0,0,0-2.995-5c-1.741-2.287-1.972-4.251.275-6.389,2.839-2.7,2.26-5.468-.285-8.049-3.8-3.853-6.517-8.446-9.271-13.052-1.272-2.128-1.779-4.072.233-5.613,3.819-2.927,3.06-6.582,2.206-10.384-.532-2.37-.958-4.765-1.484-7.136-.77-3.466.446-6.5,3.384-7.889,3.122-1.476,4.489-4.006,6.018-6.616,1.485-2.538,2.168-5.963,6.56-4.45,1.426.49,2.07-1.175,2.716-2.324.788-1.4,1.419-3.118,2.624-4.019,1.995-1.492,4.589-3.818,5.7,1.079.533,2.355,2.765,3.866,3.239,6.443,1.679,9.116,9.556,13.045,17.586,8.386,3.708-2.151,3.974-1.154,3.962,2.231-.024,6.184,4.369,10.955,5.625,16.795.367,1.713,2.591,2.432,4.455.97,1.759-1.381,3.806-2.286,5.268-4.188,1.924-2.5,4.547-4.173,8-3.68v-2.932C865.717,4711.78,866.587,4709.79,865.489,4708.44Z" transform="translate(-3.732 -3575.349)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542"></path>
                        </g>
                        <path id="Path_431" data-name="Path 431" d="M640.826,4196.05c.48,7.26.26,7.44-7.02,7.69-2,.07-4.15-.23-3.83,2.86a1.844,1.844,0,0,0,1.86,1.07,5.773,5.773,0,0,1,.93,3.89c-3.11,3.48-7.61,2.63-11.49,3.69-3.06.83-6.38.83-7.62,4.82-.55,1.79-2.79,1.17-4.37,1.25-1.91.1-3.76-.16-5.53,1.21-4.22,3.27-4.06,5.76.78,8.07,4.96,2.37,5.27,4.8,3.39,9.84-1.59,4.24-4.13,6.21-8.07,7.95a7.57,7.57,0,0,0-4.48,9.52c.25.88.44,2.431-.01,2.76-5.39,3.94-5.2,11.38-9.97,15.67-.71.64-1.18,1.77-2.26,1.58-5.48-1-10.79,2.37-16.35.4-2.81-1-4.47.51-4.23,3.47.33,3.9-1.39,6.65-3.83,9.54-1.89,2.24-2.72,5.39-4.02,8.14-3.87,1.35-3,5.02-3.85,7.85q-3.09.075-6.18.14c-2.76.32-2.81,2.45-2.6,4.37.4,3.66-1.27,5.79-4.49,7.08-.84.33-2,.43-1.98,2.02,3,2.45,8.69-1.8,10.6,3.99,1.27,3.87,5.05,6.93,3.67,11.65l-.1.09c-2.92.22-5.8.53-7.9,2.94l-.4.01-.4-.02c-2.07.27-4.14.63-6.22.77-.87.06-2.25-.84-2.28.67-.11,5.4-3.98,9.15-5.69,13.82-1.87,5.09-2.51,5.24-6.41,1.1-2.6-2.77-2.6-2.77-7.43-1.36,7.79-.76,6.08,3.98,5.51,7.91-.34,2.38-1.6,2.9-3.77,1.54a29.585,29.585,0,0,1-9.14-8.65c-2.27-3.5-4.98-4.12-8.56-4.13a33.642,33.642,0,0,1-21.13-7.4c-3.01-2.32-5.87-5.02-9.38-7.58-.1,5.69.29,9.36,5.9,12.08,7.17,3.48,13.9,7.56,22.08,7.68,6.42.09,12.32,2.35,15.66,7.36,3.18,4.77,6.69,5.94,11.68,5.33,3.34-.41,5.25,1.36,6.16,4.3,1.19,3.86,1.94,7.88,3.32,11.67,2.23,6.07-.09,10.77-4.06,14.98-1.06,1.13-2.27,2.05-1.72,3.66,1.13,3.3.9,6.97,3.57,9.88,2.15,2.34,1.62,5.79,1.84,8.79a3.368,3.368,0,0,1-2.03,3.12c-1.66.68-2.24-.74-2.95-1.82-3.09-4.72-8.53-2.39-12.65-4.1-.66-.27-1.42,1.13-1.43,2.21-5.46.48-10.25,2.18-13.86,6.66-2.16,2.67-19.66,1.86-21.71-.91-1.71-2.3-.42-5.05-.84-7.56-.31-1.92,1.31-4.95-1.43-5.5-2.55-.51-6.51-.03-7.53,2.19-1.72,3.76-4.98,5.29-7.78,7.34-4.3,3.15-6.37,8.03-10.06,11.56-1.6,1.54-1.65,3.52-2.05,5.34-1.1,4.94-3.64,7.84-9.02,7.45a6.161,6.161,0,0,0-4.15,1.141c-1.59-.32-3.19-.65-4.79-.98a3.93,3.93,0,0,0-4.95-.141c-3.01,1.931-5.41-.02-7.53-1.589-2.23-1.65-1.28-3.7.38-5.42,1.75-1.82,1.78-3.64-.65-4.63-2.92-1.18-3.26-3.35-2.94-5.91.52-4.16-.8-6.82-4.76-9.01-4.74-2.61-5.95-8.3-7.65-12.92-1.19-3.24,3.25-5.87,4.3-9.37,1.78-5.93,1.94-6.28-4.1-6.87a4.513,4.513,0,0,1-3.73-1.91c-2.04-3.25-4.25-5.85-8.61-6.23-2.32-.21-1.67-2.24-.32-3.64,1.65-1.7,2.12-3.31-.46-4.61-4.11-2.08-5.97-8.91-2.78-12.18,2.18-2.23,1.75-3.87.6-5.97a28.377,28.377,0,0,1-3.21-9.1c-.89-5.31-3.36-9.47-9.43-10.09-1.44-.14-2.73-.81-2.67-2.31.11-2.79-2.49-4.25-3.03-6.29-1.04-3.94-3.5-7.09-4.75-10.75-2.18-6.36-9.61-12.33-16.2-12.34a11.244,11.244,0,0,1-9.66-5.649c-1.71-2.75-.71-5.61,1.38-8.46,3.34-4.53,1.86-9.99,1.35-15.08-.19-1.89-2.58-1.56-4.09-1.96a3.3,3.3,0,0,1,3.86-2.8c2.75.19,5.48.36,8.22.67,4.15.47,5.97,2.56,6.54,6.42a19.14,19.14,0,0,0,1.37,5.14c1.6,3.48,3.76,3.62,6.13.68a3.162,3.162,0,0,1,5.08-.2c2.67,2.79,5.03,2.04,7.77.27,2.16-1.39,4.81-3.03,6.88-.34,1.79,2.32,3.8,2.28,6.01,1.68a27.87,27.87,0,0,1,8.72-.56c7.79.35,13.31,3.16,13.01,8.17-.43,6.9,4.2,9.54,7.86,13.43,2.63,2.8,5.34,5.04,9.38,5.33,3.46.24,6.02,1.85,8.8,4.25,2.63,2.28,5.25,5.78,8.24,6.54,6.66,1.7,13.73,1.79,19.35,7.39.94-5.09-.54-8.05-4.26-10.2-5-2.89-10.66-3.77-16.02-5.55-2.59-.85-5.52-1.22-7.19-3.76-1.11-1.69-1.95-2.71-4.51-2.61-2.5.1-4.6-2.91-3.09-5.06,2.07-2.98.05-3-1.57-3.37a22.038,22.038,0,0,1-10.59-5.63c-4.24-4.109-8.68-7.959-8.3-15.04.21-3.95-2.09-7.52-5.56-10.31-5.25-4.22-10.82-8.58-10.01-16.59.82-.17,1.64-.34,2.45-.51l.18-.23c3.12-1.39,6.59-1.45,9.77-2.85a12.292,12.292,0,0,0,3.46-20.55c-3.51-3.169-1.75-7.339-1.67-11.049a65.479,65.479,0,0,1,1.58-10.529c.6-3.2-1.22-5.13-3.27-7.11,0,0-.75-7.28,0-10.57s-1.69-13.18,0-16.47,4.84-4.24,7.5-7.53,3.14-7.87,6.43-11.7,6.22-7.13,7.11-9.01.52-5.65,0-8.47.89-5.65,4.66-4.23,4.4,3.76,7.38,3.29,7.2-3.76,8.62-6.12,9.53-4,10-2.7,0,8.35,1.53,8.35,4.58-2.24,4.82-.35.06,7.53.76,8.58,3.71,9.67,2.65,10.66-4.06,4.7-1.76,7.87,2.82,4.42,3,6.36,1.41,2.47,4.05,4.06a67.111,67.111,0,0,1,7.42,5.11c1.94,1.59,4.94,3.36,1.76,4.42s-2.65.88-2.29,4.23,1.59,4.59,2.29,5.12.66-1.59,1.39.7-2.67,4.15-2.38,7.55.8,5.23,2.48,6.61.81,5.79,2.57,6.49,2.29,1.24,3.88,1.24,4.22-1.26,4.58-1.95.01.69,1.95,0,3.14-1.42,5.01,0,2.93,1.59,4.17,1.24,1.76,1.06,2.65-.35-1.36-2.12.99-2.47,3.94-1.03,3.5-2.37-.79-2.57,0-3.1,2.21-1.59,2.92-1.42.72,1.66,3.27,2.69,6.61,1.23,7.14,1.83,2.63,2,2.02,3.95a2.555,2.555,0,0,0,1.16,3.181c.52.35.7-.351,1.76,1.24s3.57,2.29,3.99,2.64a1.764,1.764,0,0,0,2.72,0c1.41-1.23,5.21-3.53,7.37-2.47s2.86.53,2.33-1.06-1.14-2.11-2.33-5.29-.6-4.23-1.87-5.29-.67-2.3,0-4.06a39,39,0,0,0,1.87-7.94c.04-1.59,1.1-5.3-4.73-6.36s-6.84-4.58-5.36-7.41,1.48-2.82,3.07-3,3.53,0,4.41,1.59,6.88,4.24,7.41,4.24,1.59-2.3,2.3-4.95,1.94-4.23,3.35-3,1.41,4.59,2.12,5.47,1.41,1.43,1.94,1.07a7.086,7.086,0,0,0,1.94-3.71c.35-1.77-.71-2.47.88-2.47s7.06,2.3,8.47-1.32a37.475,37.475,0,0,0,2.12-8.041c.35-1.939.71-4.229,1.59-4.229s.28,2.29,2.12,1.59,1.94-1.41,2.64-2.3.53-.88,2.47-.88h6.18c1.06,0,.53-1.94,2.29-2.12s1.95,1.41,3.36,1.41,2.11-2.64,3.53-1.58,3,1.94,5.29,1.06,4.24-4.11,5.12-3.82.17.82,1.76,1.52,2.12-.88,4.41.18,1.42,1.59,3.53,1.94,3.89-.35,4.59-1.59-1.23-3.71,0-4.23a5.789,5.789,0,0,1,4.41-.36,37.614,37.614,0,0,0,6.79.529h4.16l.66.29c.24,1.14,1.13,2.39,2.67,4.16,2.18,2.5,2.99,5.22,1.28,8.02-2.54,4.15-1.79,7.04.48,11.56,2.12,4.2.66,10.37,2.21,15.56C642.7,4193.28,640.706,4194.31,640.826,4196.05Z" transform="translate(-1008.216 -3608.873)" fill="none" stroke="#0b612d" stroke-width="2.54" class="main-division active"></path>
                        <path id="Path_424" data-name="Path 424" d="M384.29,4637.18c.087.016.207,0,.252.054a.768.768,0,0,1,.121.249ZM342.555,4614c-.861.049-2.189.424-2.265-.893-.081-1.4,1.133-2.2,2.361-2.568a1.985,1.985,0,0,1,2.586,1.477C345.084,4613.63,343.847,4613.92,342.555,4614Zm-.2,23.927c-3.614-3-5.118-6.72-8.939-7.946a2.018,2.018,0,0,1-.463-3.3c1.041-1.037,3.192-1.281,3.387-.293.829,4.2,6.407,5.7,6.013,11.532Zm-37.893-9.48a.7.7,0,0,1,.08.212l-.312-.307c.078.028.192.028.23.088ZM436.9,4503.463c-.366-8.039-3.626-15.612-2.779-23.715.309-2.959-2.35-3.453-4.808-3.442-1.987.009-4.079.141-4.464-2.583a4.357,4.357,0,0,1,2.886-5.047c2.169-.92,5.346-1.02,5.667-3.867.485-4.309.748-8.754-1.954-12.721-.895-1.314-2.5-2.153-2.714-3.929a3.921,3.921,0,0,0-4.956-.144c-3,1.922-5.41-.023-7.529-1.594-2.227-1.649-1.28-3.7.378-5.417,1.758-1.819,1.782-3.647-.652-4.629-2.918-1.18-3.252-3.352-2.932-5.914.519-4.156-.8-6.824-4.767-9.012-4.732-2.608-5.947-8.3-7.645-12.919-1.189-3.236,3.244-5.867,4.3-9.365,1.783-5.929,1.941-6.288-4.1-6.871a4.521,4.521,0,0,1-3.733-1.915c-2.044-3.247-4.246-5.844-8.613-6.23-2.315-.205-1.67-2.239-.319-3.638,1.647-1.7,2.125-3.307-.46-4.612-4.108-2.074-5.972-8.909-2.78-12.178,2.179-2.231,1.753-3.867.6-5.968a28.427,28.427,0,0,1-3.208-9.1c-.887-5.309-3.36-9.471-9.436-10.089-1.435-.146-2.722-.812-2.663-2.316.109-2.789-2.491-4.247-3.03-6.287-1.042-3.936-3.506-7.094-4.755-10.746-2.176-6.366-9.6-12.337-16.2-12.341a11.278,11.278,0,0,1-9.666-5.649c-1.706-2.754-.7-5.617,1.388-8.458,3.334-4.536,1.857-10,1.347-15.082-.19-1.889-2.579-1.564-4.1-1.969-4.311.453-6.437-3.229-9.477-5.133a1.716,1.716,0,0,1,.175-2.913c4.6-2.435,1.047-4.024-.6-5.548-2.513-2.328-5.606-2.228-8.682-1.326-1.758.516-2.947,1.45-1.709,3.536.442.746,1.656,1.515.658,2.455-.879.829-2.732.821-3.137.116-3.084-5.371-9.709-4.648-13.869-8.259a4.021,4.021,0,0,1-1.625-4c-3.9-1.46-7.535-2.951-7.071-8.331.342-3.966-.281-8.983-3.888-10.254-4.389-1.545-9.423-3.428-14.331-2.057a23.05,23.05,0,0,1-18.111-1.951c-5.806-3.14-10.125-9.958-18.212-7.811.639,6.788-1.79,14.47,5.707,19.256.964.615.326,1.7.363,2.624.114,2.862.009,5.97,1.115,8.487,1.019,2.32,3.858-1.1,5.709.5.1.082.087.284.226.8-5.078.967-6.165,4.112-4.615,8.772.576,1.734.456,3.871-1.972,4.2-2.745.365-4.34,2.24-5.869,4.042-2.428,2.859-4.684,3.779-8.391,1.879-4.055-2.077-5.491.075-6.46,4.624-.773,3.629,3.95,9.234-3.189,11.038a1.493,1.493,0,0,0-.3,1.312c2.266,2.96.53,5.279-.636,8.083-.81,1.949-1.19,4.822.693,6.95.831.938,1.49,2.209.489,3.016-3.933,3.165-2.582,5.293,1.115,7.152.809.407,1.383,1.116,1.121,1.943-1.9,5.994,2.372,4.9,5.637,4.969,3.169.069,5.617.768,4.455,4.846a3.5,3.5,0,0,0,1.619,4.225c3.173,1.938,5.734,4.659,9.074,6.459,3.535,1.906,5.622,5.892,6.089,9.434.36,2.74-.143,6.074-.543,9.1a13.635,13.635,0,0,1-6.684,9.974c-3.468,2.139-4.109,5.829-.962,8.691a6.006,6.006,0,0,1,1.84,2.148c1.441,3.5,11.147,9.1,14.629,8.443a4.654,4.654,0,0,0,2.593-1.189c1.054-1.249,2.081-.765,3.384-.759,5.563.017,10.929.177,14.416,5.525.238.365.82.506,1.241.751,0,.563.007,1.125.008,1.688-.737.631-1.72,1.125-2.164,1.92-1.23,2.211-.435,5.124-3.846,6.639-5.361,2.384-6.641,6.686-5.015,12.371a4.9,4.9,0,0,1-.347,4.235c-2.269,3.4-1.965,7.357-2.351,11.157-.119,1.184.045,2.472,1.439,2.727,4.2.772,4.16,3.944,4.845,7.225.787,3.764,1.023,8.659,7.269,8,1.583-.165,3.082,5,1.738,6.195a7.372,7.372,0,0,0-2.651,6.445c.063.949,0,2.154-1.2,2.373-6.7,1.211-2.628,6.115-1.412,7.292,4.431,4.287,3.5,7.969.53,12.3-1.511,2.2-2.563,4.669,1.272,6.114,2.34.882,2.95,2.733,1.983,5.149-1.379,3.446-1.513,6.568,2.476,8.572a2.225,2.225,0,0,1,1.058,2.965c-1.449,2.887.2,4.94,1.57,7.153,2.188,3.531,2.816,7.057.2,10.775a4.771,4.771,0,0,0,.059,5.53c1.439,1.854,1.384,3.39.7,5.364-1.417,4.055-2.413,8.024,4.709,7.545-4.039,3.244-3.687,6.826.281,10.18,4.534,3.832,6.991,8.9,8.352,14.567.222.924.071,2.348.63,2.711,3.5,2.269,1.186,3.214-.906,3.139-4.257-.15-4.291,2.83-4.434,5.471-.261,4.788,2.43,8.646,4.635,12.61.461.827,1.674,1.954,1.462,2.326-2.722,4.758-.33,10.119-1.833,15.588-2.306-4.079-3.827-3.9-5.36.042-.8,2.064-.9,3.521.39,5.363,2.908,4.163,4.04,8.6,1.813,13.591-.61,1.367-1.09,3.691.325,4.6,3.771,2.429,5.393,6.253,7.649,9.783,1.772,2.771,7.134,2.823,7.164.593.054-4.054,2.9-8.674-1.706-12.1a2.011,2.011,0,0,1-1.891-.951c.791-.02,1.537.055,1.892.947,1.9-.406,3.553,1.061,5.691.317,3.641-1.269,6.3.911,5.614,4.668-.4,2.19-.313,3.678,1.275,5.21,2.144,2.069.471,3.922-.674,5.607-1.18,1.736-2.652,3.274-3.978,4.912-.754.929-1.3,1.831-.235,2.989,2.4,2.606,10.468,3.235,14.22,1.04,4.374-2.558,5.7-5.827,4.345-10.749,1.068-.511,1.937.112,2.685.65,3.062,2.2,5.511,2.938,6.465-1.968.249-1.278.909-1.5,2.408-.56,4.485,2.83,9.819,2.607,11.9-1.962.77-1.693,2.369-3.065,3.756-4.41,2.874-2.785,4.67-6.5,1.683-9.382-6.41-6.172-.929-9.057,2.612-12.729,1.222-1.268,2.375-2.6,3.568-3.919.66,8.919-.692,17.988,4.554,25.946,1.153,1.747.273,3.43-.431,5.091-.488,1.15-1.263,2.162.463,3.261,3.9,2.483,7.9,3.021,11.909.783,3.454-1.929-.4-4.649.344-6.959,3.4-.015,6.814-.241,10.19.024,3.15.247,4.153-1.473,5.112-3.975,1.076-2.811-.3-4.273-2.309-5.637-1.341-.91-2.756-1.729-4-2.753-1.163-.953-1.246-2.206.543-2.216,3.807-.017,8.021-1.353,11.23,1.529,2.768,2.487,5.1,1.954,7.7.175,1.733-1.187,3.515-2.314,5.166-3.606,8.013-6.268,8.081-10.087,5.8-19.757-1.906-8.092-4.159-16.987.8-25.216,2.7-8.813-2.187-16.221-4.263-24.2a16.114,16.114,0,0,1,2.153-13.4,24.329,24.329,0,0,0,4.9-14.382c-.01-3.473,1.4-5.952,4-8.741,2.676-2.887,5.421-6.107,5.156-11.947Z" transform="translate(-1008.913 -3608.559)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542" class="main-division"></path>
                        <path id="Path_440" data-name="Path 440" d="M643.676,4142.25a3.888,3.888,0,0,1-.32,1v.01a5.524,5.524,0,0,1-.57.88,4.016,4.016,0,0,1-.49.529c-.18.17-.37.33-.57.49s-.42.31-.64.46-.46.28-.7.42a8.4,8.4,0,0,0-1.42,1.32c-2.51,2.4-3.58,3.82-3.24,5.49l-.66-.29h-4.16a37.615,37.615,0,0,1-6.79-.53,5.786,5.786,0,0,0-4.41.36c-1.23.52.71,3,0,4.23s-2.47,1.94-4.59,1.59-1.23-.88-3.53-1.94-2.82.53-4.41-.18-.88-1.23-1.76-1.52-2.83,2.93-5.12,3.82-3.88,0-5.29-1.06-2.12,1.58-3.53,1.58-1.59-1.58-3.36-1.41-1.23,2.12-2.29,2.12h-6.18c-1.94,0-1.76,0-2.47.88s-.81,1.59-2.64,2.3-1.24-1.59-2.12-1.59-1.24,2.29-1.59,4.23a37.46,37.46,0,0,1-2.12,8.04c-1.41,3.621-6.88,1.32-8.47,1.32s-.53.7-.88,2.47a7.082,7.082,0,0,1-1.94,3.71c-.53.36-1.24-.18-1.94-1.07s-.71-4.23-2.12-5.47-2.65.36-3.35,3-1.77,4.95-2.3,4.95-6.53-2.65-7.41-4.24-2.82-1.76-4.41-1.59-1.59.18-3.07,3-.46,6.35,5.36,7.41,4.77,4.77,4.73,6.36a39.008,39.008,0,0,1-1.87,7.94c-.67,1.76-1.27,3,0,4.06s.67,2.11,1.87,5.29,1.8,3.71,2.33,5.29-.17,2.12-2.33,1.06-5.96,1.24-7.37,2.47a1.764,1.764,0,0,1-2.72,0c-.42-.35-2.93-1.05-3.99-2.64s-1.24-.89-1.76-1.24a2.554,2.554,0,0,1-1.16-3.18c.61-1.95-1.49-3.35-2.02-3.95s-4.59-.81-7.14-1.83-2.57-2.51-3.27-2.69-2.12.89-2.92,1.42-.44,1.76,0,3.1-1.14,2.01-3.5,2.37-.11,1.06-.99,2.47-1.42,0-2.65.35-2.3.18-4.17-1.24-3.07-.7-5.01,0-1.59-.7-1.95,0-2.99,1.95-4.58,1.95-2.12-.53-3.88-1.24-.88-5.12-2.57-6.49-2.19-3.21-2.48-6.61,3.11-5.25,2.38-7.55-.68-.17-1.39-.7-1.94-1.77-2.29-5.12-.89-3.18,2.29-4.23.18-2.83-1.76-4.42a67.1,67.1,0,0,0-7.42-5.11c-2.64-1.59-3.88-2.12-4.05-4.06s-.71-3.18-3-6.36.7-6.88,1.76-7.87-1.94-9.6-2.65-10.66-.53-6.7-.76-8.58-3.3.35-4.82.35-1.06-7.06-1.53-8.35-8.59.35-10,2.7-5.65,5.65-8.62,6.12-3.62-1.88-7.38-3.29-5.18,1.41-4.66,4.23.89,6.59,0,8.47-3.81,5.18-7.11,9.01-3.76,8.4-6.43,11.7-5.8,4.23-7.5,7.53.75,13.17,0,16.47,0,10.57,0,10.57c-2.86-2.78-6.41-5.15-3.13-10.23,1.32-2.03-1.21-4.38-3.04-5.5-3.91-2.38-2.78-5.07-.66-7.51,3.24-3.72,4.78-7,.95-11.48-1.98-2.31.74-3.58,2.67-4.53,5.8-2.84,6.02-3.3,3.42-9.34a2.2,2.2,0,0,1,.62-2.911c4.25-4.379,4.89-9.5,1.75-14.24a3.486,3.486,0,0,1-.43-3.96c1.73-3.77.17-5.97-3.92-5.3s-5.76-1.71-5.35-4.76c.34-2.58-.48-3.26-2.27-4.41-5.37-3.48-6.31-6.91-4.28-12.98,1.14-3.4-1.19-6.24-2.09-9.27-.57-1.9-1.64-3.48.07-5.34.44-.48.63-1.98.31-2.25-3-2.45-1.42-6.29-2.94-9.15.38-1.4,1.42-3.03,1.03-4.17-2.03-6.04,1.22-9.7,5.21-13.3a6.415,6.415,0,0,0,1.85-4.89c.02-4.28,2.3-6.85,6.29-8.23,5.63-1.96,6.96-4.59,4.48-9.96a26.389,26.389,0,0,1-2.08-12.84c.21-4.01,3.15-7.09,3.79-11.19.32-2.03,4.54-.08,6.48,1.51.89.74,1.11,2.3,1.63,3.48-3.44,5.9,1.48,10.67,2.45,15.93.35,1.89,3.23,3.56,6.03,1.46a15.265,15.265,0,0,1,17.41-.24c8.86,6.41,18.69,9.92,29.53,11.51,7.11,1.05,13.91,4.05,20.99,5.39,5.84,1.11,9.79,6.33,16.18,6.27,3.01-.02,5.9.09,8.35-1.49,6.53-4.21,13.92-2.15,20.87-2.95,2.25-.26,4.42.74,6.57-1.18,1.37-1.23,2.97-.08,4.33,1,4.89,3.88,7.49,3.95,12.34.3,2.85-2.15,5.35-3.75,7.68.78,1.01,1.97,3.41,2.06,5.59,2.31,5.63.65,11.2-1.2,16.82-.14,1.42.27,2.23-1.13,3.27-1.88,2.08-1.49,3.99-3.45,6.94-2.9-.46,4.14-2.73,8-1.87,12.35.41,2.06,1.33,4.32.85,6.19-1.85,7.23-3.16,14.06-.21,21.61,1.32,3.38,1.28,6.49,5.65,6.83a3.848,3.848,0,0,1,2.81,1.79c2.12,2.97,5.39,3.51,8.57,3.93,7.56,1,8.67,1.9,9.69,9.19.22,1.6.53,3.43,2.48,1.95,2.84-2.14,4.69-1.48,6.38,1.21a5.437,5.437,0,0,1-.63,7.04c-.16.19-.33.36-.51.541-.09.09-.18.17-.27.26-4.65,4.35-4.29,6.12,1.89,8.24,1.07.37,2.17.68,3.27.96a7.725,7.725,0,0,1,5.91,5.79A4.684,4.684,0,0,1,643.676,4142.25Z" transform="translate(-1007.557 -3608.331)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542" class="main-division"></path>
                        <path id="Path_423" data-name="Path 423" d="M422.188,3932.15a4.282,4.282,0,0,0,2.436-5.334c-.765-2.137-2.742-3.034-4.915-3.418-.752-.134-1.5-.312-2.765-.582,3.395-3.408,4.932-6.238-1.438-6.718-.474-.036-1.11-.772-1.3-1.311-1.1-3.146-1.383-6.754-5.311-8.1-.5-.17-.576-1.163.022-1.69,2.487-2.19.608-4.2-.366-6.1-1.257-2.445-3.535-4.579-4.087-7.125-1.073-4.95-3.876-6.184-8.362-5.639-1.163.142-2.744.588-3.368-1.1-.512-1.384.164-2.508,1.048-3.548.818-.962,2.349-2.131,1.285-3.291-2.191-2.387-4.711-4.537-8.47-3.532-2.864.765-5.269,1.724-4.768,5.475a6.019,6.019,0,0,1-4.174,6.915c-3.075,1.1-3.023,2.935-2,5.352.744,1.766,2.129,3.578.642,5.471-2.029,2.585-.3,3.746,1.579,4.968,2.115.059,4.977-5.212,6.135,1.3-1.395,1.137-3.395.274-5.144.644-1.278.975-2.534,1.982-3.839,2.922a6.471,6.471,0,0,0-1.806,9.033c.471.793,2.922.266,1.528,2.074a3.347,3.347,0,0,1-2.571,1.135c-1.583-.187-1.139-1.724-1.14-2.771-.007-3.621-1.884-4.838-5.3-4.561a46.243,46.243,0,0,1-6.832-.007c-2.322-.157-4.247-.9-5.506-3.28-1.906-3.6-4-3.492-6.184.183-1.046,1.758-1.915,3.336-4.377,3.134-2.856-.235-14.774-8.473-15.372-11.251-1.376-6.393-6.014-8.59-11.639-9.157-2.918-.294-4.47-1.415-5.259-4.065-2.106-7.062-2.49-14.893-8.879-20.068-.082-.066-.018-.313-.022-.476l-.413-.4c.09.019.215.008.262.064a1.269,1.269,0,0,1,.152.338c2.545-.209,5.8.234,6.429-3.009.537-2.764-1.474-4.882-4.062-6-2.573-1.112-2.979-3-2.56-5.508.412-2.477.37-5.787-2.638-5.777A18.9,18.9,0,0,1,286.4,3843.3c-1.925-1.5-4.97-1.425-5.494-4.775-.241-1.534-1.739-.8-2.851-.636-4.907.744-6.573,4.8-8.82,8.347-2.845,4.5-1.656,8.4,2.856,11.143,2.6,1.584,5.176.629,7.88.828-.189.783-.151,1.385-.433,1.665-1.874,1.86-1.653,3.842-.215,5.7,1.385,1.79,3.1,1.378,4.684.153.743-.575,1.579-.906,1.887.191.593,2.1,2.037,2.72,3.976,2.923a1.738,1.738,0,0,1,1.6,1.58c.109,1.066-.881,1.226-1.522,1.644-5.32,3.472-12.1,1.708-16.557-4.3-2.182-2.943-7.839-4.227-10.817-2.346-3.482,2.2-4.685,4.905-1.227,8.54-2.315-1.482-5.527-1.257-5.221-5.29.494-6.5-3.326-8.847-9.217-6.05-.346.316-.687.9-1.038.906-1.885.028-3.193,2.3-5.253,1.328-.212-.1-.291-.941-.127-1.3,1.179-2.564,3.6-1.389,5.516-1.76-.53-3.42-.413-7.013-5.562-7.317-2.371-.14-4.409-1.915-3.308-5.246a2.909,2.909,0,0,0-2.027-3.88c-4.821-1.534-8.58-4.314-10.707-9.056-.574-1.281-1.865-2.563-3.027-1.6-5.467,4.541-7.994-1.471-10.793-3.522-3.71-2.72-6.146-7.126-11.413-7.678-.849-.089-1.661-.934-2.407-1.534-4.656-3.745-3.409-9.012-3.544-13.921h-3.908c-4.9,6.557-6.17,14.9-10.559,21.665-2.37,3.654-.4,6.57.922,9.56.725,1.641,1.951.912,3.01-.3,2.935-3.349,6.18-4.5,9.8-.868.332.332.888.823,1.2.738,10.984-3,7.132,8.911,12.026,12.073.678.438.325,2.135-.792,2.961-1.46,1.08-2.489.392-3.227-.826-1.485-2.451-2.708-2.086-3.526.338a3.783,3.783,0,0,1-3.1,2.708,7.039,7.039,0,0,0-5.055,4.076c-1.411,2.821-4.33,3.255-7.091,3.492-2.9.249-3.542,1.825-3.079,4.32.059.318.222.618.275.937,1.656,10.035-3.382,14.772-13.6,12.818-3.5-.667-7.15-1.545-6.557,4.223a2.18,2.18,0,0,1-1.837,2.532c-4.48.288-5.016,3.673-5.942,6.933a11.7,11.7,0,0,1-1.9,3.907c-1.476,1.9-.9,3.208.7,4.559,3.524,2.978,3.713,5.175-.288,7.325-8.69,4.667-9.373,13.922-12.871,21.5-.874,1.9-1.955,5.738,2.566,6.416a1.174,1.174,0,0,1,.924,1.492c-1.921,5.661,3.47,8.2,5.255,12.257,1.01,2.3,3.09,2.3,4.851.758,2.066-1.81,3.611-3.856,6.913-1.566,1.189.825,3.565-.852,5.053-2.26.935-.883,2.113-1.656,3.268-.074,3.567,4.883,7.623,9.143,13.173,11.941,3.3,1.664,3.632,6.252,7.317,8.079,1.975.979,3.445,2.8,6.006,2.466,1.077-.14,2.437-.216,2.8,1.269a3.486,3.486,0,0,1-1.3,3.752c-2.907,2.748-2,8.254,1.7,8.964,6.072,1.163,7.913,6.487,11.15,10.212,1.983,2.28,3.545,3.273,6.349,3.144,4.981-.229,9.459.58,13.517,4.244,1.882,1.7,5.6,2.243,8.378,1.506,3.972-1.055,7.507-3.414,11.973-3.09,1.614.117,1.022-3.384,3.428-3.813,1.2.22.258,1.757.958,2.252,5.609,3.966,5.851,8.091.517,12.5a1.2,1.2,0,0,0-.238,1.748c4.023,4.045,5.011,10.415,10.337,13.456,4.662,2.661,9.482,4.574,15.028,4.461,2.591-.053,6.4-1.319,6.275,3.656-.257,2.367.586,3.644,2.973,4.729,4.666,2.121,10.8,0,14.44,5.1.338.475,1.866.113,2.843.118,1.954.011,3.909.058,5.861,0,2.533-.079,3.838.871,2.883,3.5-1.373,3.783.333,6.243,3.3,8.227,1.915,1.282,4.316,2.7,4.6,4.835.714,5.48,4.359,5.19,8.187,4.946,4.476-.287,8.8.37,10.829,4.808,1.858,4.07,4.615,4.138,8.308,3.71,3.208-.371,7.4-1.786,9.569.214,3.581,3.3,8.292,2.37,11.963,4.751,1.24.8,3.909.914,5.069-.528,2.926-3.639,6.788-3.276,10.677-3.215.38-1.4,1.417-3.029,1.03-4.173-2.036-6.032,1.215-9.7,5.2-13.3a6.43,6.43,0,0,0,1.856-4.888c.019-4.281,2.3-6.852,6.285-8.235,5.632-1.952,6.958-4.593,4.48-9.959a26.4,26.4,0,0,1-2.076-12.835c.207-4.017,3.144-7.1,3.791-11.2.319-2.021,4.541-.078,6.474,1.52.893.737,1.109,2.292,1.634,3.477,2.769-1.52,1.495-4.413,2.17-6.625,3.756-12.317,7.093-24.718,6.5-37.809a4.516,4.516,0,0,0-2.513-4.31c-3.785-1.925-1.4-7.183-5.021-9.167.245-.416.391-.969.75-1.227,4.193-3.017,2.129-6.109.2-9.249-.5-.807-1.382-2.069-1.1-2.55C417.956,3942.37,415.671,3935.28,422.188,3932.15Z" transform="translate(-1008.85 -3609.004)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542" class="main-division"></path>
                        <path id="Path_422" data-name="Path 422" d="M407.2,4229.52c-3.514-3.168-1.751-7.339-1.672-11.05a65.9,65.9,0,0,1,1.579-10.523c.6-3.208-1.215-5.13-3.266-7.118-2.86-2.77-6.412-5.151-3.13-10.228,1.314-2.033-1.211-4.379-3.043-5.5-3.907-2.385-2.779-5.072-.659-7.5,3.24-3.724,4.778-7.007.951-11.489-1.977-2.312.739-3.574,2.671-4.524,5.8-2.848,6.015-3.3,3.414-9.344a2.209,2.209,0,0,1,.62-2.911c4.25-4.377,4.9-9.5,1.748-14.238a3.5,3.5,0,0,1-.427-3.962c1.733-3.769.174-5.972-3.913-5.3s-5.766-1.707-5.357-4.75c.346-2.584-.48-3.259-2.267-4.416-5.374-3.473-6.312-6.911-4.28-12.982,1.136-3.4-1.193-6.241-2.1-9.272-.565-1.9-1.633-3.477.075-5.332.443-.479.632-1.986.309-2.251-3-2.455-1.416-6.3-2.935-9.152-3.891-.061-7.754-.423-10.68,3.215-1.16,1.443-3.829,1.333-5.068.528-3.672-2.381-8.382-1.452-11.964-4.751-2.17-2-6.361-.585-9.568-.214-3.693.428-6.45.36-8.309-3.71-2.025-4.437-6.352-5.094-10.828-4.808-3.828.244-7.473.534-8.188-4.946-.278-2.134-2.679-3.554-4.594-4.835-2.963-1.983-4.668-4.444-3.3-8.227.956-2.634-.349-3.584-2.882-3.5-1.952.059-3.908.013-5.861,0-.977,0-2.505.357-2.844-.118-3.637-5.1-9.773-2.977-14.439-5.1-2.387-1.085-3.231-2.362-2.974-4.73-8.458,1.236-9.915,2.645-10.61,10.261-.447,4.9-2.828,6.268-7.514,4.232a10.813,10.813,0,0,1-2.447-1.59c-3.832-3.127-6.851-3.293-9.24,1.826-.96,2.056-2.968,3.236-4.837.376-1.606-2.456-4.053.526-5.824-.838-6.766-5.212-14.427-1.835-21.693-2.371-4.068-.3-3.59,3.582-5.832,5.386-1.4-5.05-6.124-3.99-9.569-5.526-3.624-1.613-6.223-1.1-9.319,1.2-3.4,2.517-4.223,5.864-.989,8.635,1.565,1.341,2.028,1.956-.026,2.994-.544.275-1.4.9-1.343,1.253.85,5.549-4.351,10.663-1.183,16.335.8,1.426.2,2.083-.851,3.219-2.618,2.842-5.866,5.4-6.319,9.7a1.838,1.838,0,0,1-2.379,1.808c-5.478-1.786-6.193,3.738-8.993,5.915-1.084.843-.309,2.99.762,4.314a1.682,1.682,0,0,1-2.63-.221c-3.111-3.6-7.451-6.27-9.114-10.967-.906-2.558-2.913-2.082-4.372-1.822a33.6,33.6,0,0,0-8.557,2.622c-4.983,2.39-5.293,4.133-2.254,8.81,2.554,3.93,2.237,7.822-1.743,9.842-4.872,2.472-6.519,7.764-10.666,10.743a2.815,2.815,0,0,0-.754,2.216c.6,6.128-2.691,9.484-7.966,11.5v.977c4.129,2.551,5.6,7.414,9.272,10.631,2.144,1.877,5.492,5.9,3.645,10.783-1.315,3.477,2.933,10.372,6.448,10.758,3.675.4,5.717,2.711,7.922,5.018.672.7,1.169,1.842,2.172,1.765,6.729-.5,12.476,3.54,18.9,4.024,3.34.25,4.876,2.033,6.289,4.44a14.546,14.546,0,0,0,10.358,7.289c1.989.36,3.236,2.077,4.637,2.713,4.505,2.042,7.372,6.144,11.71,8.221,1.6.767,3.122,1.129,4.419-.382,1.739-2.028,3.437-1.559,5.6-.544,4.741,2.221,9.51,3.509,14.2-.572,1.73-1.5,3.738-.923,4.663,1.432.77,1.96,2.075,4.048,1.909,5.971-.384,4.421,3.294,10.288-3.919,12.712-.94.317-.706,1.7-.662,2.676,8.088-2.148,12.407,4.671,18.212,7.812a23.052,23.052,0,0,0,18.111,1.95c4.908-1.372,9.943.512,14.331,2.057,3.608,1.271,4.231,6.287,3.888,10.253-.464,5.38,3.175,6.873,7.072,8.332a18.88,18.88,0,0,1,14.584.49c1.169.53,2.495,1.458,3.6,1.276,8.307-1.374,12.254,4.292,16.433,9.76,1.531,2,2.909,4.084,5.933,4.5,4.05.558,5.619-1.025,4.592-5.1-.311-1.232-2.093-2.9-.2-3.817,1.858-.9,3.229.275,4.816,1.936,6.1,6.38,9.524,15.463,18.9,18.651,2.263.77,3.936,1.288,6.343.356,5.58-2.16,11.162-4,17.3-.884a11.2,11.2,0,0,0,11.209-.368c2.624-1.59,1.7-3.572-.051-3.7-7.244-.521-8.558-6.063-11.184-11.175-3.108-6.055-2.543-6.187,2.117-12.9l2.459-.518.168-.229c3.125-1.387,6.6-1.449,9.777-2.843a12.3,12.3,0,0,0,3.465-20.56Z" transform="translate(-1007.762 -3608.964)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542" class="main-division"></path>
                        <path id="Path_441" data-name="Path 441" d="M836.546,4108.66a2.06,2.06,0,0,1-1.15.78c-7.44.91-14.78,3.55-22.4.85a9.21,9.21,0,0,0-6.7.25c-2.72,1.15-5.84,1.63-2.93,5.97,1.53,2.29.21,5.23-.95,7.89-4.04,9.31-8.65,18.51-11.38,28.22-1.49,5.28-3.33,8.94-7.95,11.66-3.7,2.16-4.94,9.22-2.3,12.83,3.63,4.98.2,8.89-1.44,13.14-1.35,3.53-4.37,2.57-7.03,2.8-5.37.47-10.5-1.6-16.48-1.68,1.83,2.35,2.33,4.66,2.96,6.92.66,2.38-.96,3.15-2.71,3.87-2.02.83-2.5-.49-3.08-1.98-.53-1.39-.6-3.69-2.96-2.97-2.27.69-1.44,2.51-1.39,4.38.18,5.98,2.14,12.19-2.26,17.79-1.68,2.14-1.08,5.33-1.28,8.09-.13,1.86.27,4.2-2.63,4.38-2.27.15-4.09.21-5.4-2.71-2.43-5.39-5.77-10.38-12.97-9.63-1.93.2-2.43-1.81-4.07-2.61-.04,3.81-1.06,7.24.71,10.47,1.23,2.26,1.51,4.25-.98,5.91-2.51,1.69-4.6.32-6.04-1.3-2.1-2.36-4.72-3.94-7.05-5.94-.84-.72-1.3-1.86-2.77-1.2a2.95,2.95,0,0,0-1.71,3.18,15.782,15.782,0,0,0,.03,2.92c1.28,5.91-1.78,9.15-6.81,11.14-4.76,1.88-9.56,3.26-14.29-.07-1.92-1.34-3.9-2.37-6.33-1.95-3.32.58-5.89-1.55-8.8-2.42-1.3-.39-2.61-.75-3.69.25-1.45,1.34.02,2.36.65,3.32a6.914,6.914,0,0,1,.04,8.25c-1.82,2.55-3.62,4.96-3.92,8.2-.16,1.78-1.59,1.9-2.93,1.72-1.92-.27-3.82-.71-5.74-1.08.08-2.4-.26-4.8,1.44-6.98a3.553,3.553,0,0,0-.16-4.56c-3.16-3.22-2.3-7.14-2.33-10.94-.01-.97.42-2.15.01-2.88-2.02-3.61-2.02-6.17,2.84-6.94.42-.07,1.14-1.1,1.02-1.39-1.71-4.09.28-6.91,2.71-9.97,1.18-1.49.51-3.83-1.35-5.15-1.76-1.25-4.1-1.61-5.3.13-4.89,7.06-10.56,5.33-16.53,1.94a5.772,5.772,0,0,0-.93-3.89c-.34-.83-1.08-.99-1.86-1.07-.32-3.09,1.83-2.79,3.83-2.86,7.28-.25,7.5-.43,7.02-7.69-.12-1.74,1.87-2.77,1.54-3.9-1.55-5.19-.09-11.36-2.21-15.56-2.27-4.52-3.02-7.41-.48-11.56,1.71-2.8.9-5.52-1.28-8.02-1.54-1.77-2.43-3.02-2.67-4.16-.34-1.67.73-3.09,3.24-5.49a8.4,8.4,0,0,1,1.42-1.32c.24-.14.47-.28.7-.42a7.416,7.416,0,0,0,.64-.46,6.891,6.891,0,0,0,.57-.49,4.015,4.015,0,0,0,.49-.53,5.551,5.551,0,0,0,.57-.88v-.01a3.9,3.9,0,0,0,.32-1,4.684,4.684,0,0,0-.12-2.111,7.725,7.725,0,0,0-5.91-5.79c-1.1-.28-2.2-.59-3.27-.96-6.18-2.12-6.54-3.89-1.89-8.24.09-.09.18-.17.27-.26.18-.18.35-.35.51-.54a5.437,5.437,0,0,0,.63-7.04c-1.69-2.69-3.54-3.35-6.38-1.21-1.95,1.48-2.26-.35-2.48-1.95-1.02-7.29-2.13-8.19-9.69-9.19-3.18-.42-6.45-.96-8.57-3.93a3.849,3.849,0,0,0-2.81-1.791c-4.37-.339-4.33-3.449-5.65-6.83-2.95-7.55-1.64-14.38.21-21.61.48-1.87-.44-4.13-.85-6.19-.86-4.35,1.41-8.21,1.87-12.35,5.96-1.47,11.94-2.6,17.98-1.8a28.225,28.225,0,0,1,4.52.96c4.46,1.34,8.68-.79,12.87-1.44a21.136,21.136,0,0,1,13.5,2.24c3.39,1.71,6.47,3.78,11.12,2.28,3.78-1.22,7.75,1.83,11.09,4.1,3.23,2.19,5.9,2.34,9.86,1.21,4.44-1.26,9.1-1.67,13.23-4.1,1.41-.83,2.54-.31,2.59,1.54a5.916,5.916,0,0,0,5.17,5.51c2.74.47,6.28.09,7.29-3.9.14-.54,1-1.42,1.26-1.33,5.89,1.99,10.24-3.46,15.74-3.18a139.45,139.45,0,0,0,23.29-.77c3.47-.4,6.73.7,10.59-.91,3.46-1.45,8.64-1.71,12.34.49a168.563,168.563,0,0,0,19.06,10.17c4.1,1.77,7.73,5.8,12.62,7.16a5.7,5.7,0,0,0,3.8.1c2.85-1.14,5.1-1.32,5.26,2.8.06,1.56,1.61,2.06,2.86,2.22,2.72.34,4.72,2.11,7.06,3.19,1.94.9,3.2,2.12,2.22,4.59-.84,2.1.39,4.66,1.7,5.17,3.32,1.28,4.55,4.6,7.37,6.25C836.876,4096.54,838.586,4106.08,836.546,4108.66Z" transform="translate(-1007.578 -3607.693)" fill="none" stroke="#0b612d" stroke-miterlimit="10" stroke-width="2.542" class="main-division"></path>
                        <text text-anchor="middle" style="">
                        <textPath xlink:href="#Path_426" startOffset="50%">
                        Barishal
                        </textPath>
                    </text>
                    </g>


                </svg>
            </div>
            <div class="col-lg-6 col-md-6 col-12 p-4">
                <div class="location-division">
                    <h2><span class="division_name" id="division_name">{{$division->name??'Dhaka'}}</span> Division</h2>
                </div>
                <div class="location-search">
                    <input id="search_by_location" type="text" placeholder="type your location..">
                </div>
                <div class="location-image">
                    <img id="health_center_banner_image" src="{{$healthCares[0]->banner_image??''}}" alt="">
                </div>
                <div class="location-title">
                    <h2 id="health_center_name">{{$healthCares[0]->name??''}}</h2>
                </div>
                <div class="location-contact">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-12">
                            <p><span class="contact-icon"><i class="fas fa-map-marker-alt"></i></span><span id="address">{{$healthCares[0]->address??''}}</span>, <span id="district_name">{{$healthCares[0]->getDistrict->name??''}}</span>
                            <!--, <span id="upazilla_name">{{$healthCares[0]->getUpazilla->name??''}}</span>-->
                            </p>
                        </div>
                        <div class="col-lg-6 col-md-6 col-12">
                            <p><span class="contact-icon"><i class="fas fa-phone-alt"></i></span><span id="contact_info">{{$healthCares[0]->contact_info??''}}</span></p>
                        </div>
                    </div>
                </div>
                <div class="location-options-table">
                    <table id="tableMain">
                        <tbody id="health_center_list_table">
                            @foreach($healthCares as $key=>$healthCare)
                                <tr class="health_care_list_tr @if($key==0) active @endif" health_care_id="{{$healthCare->id??''}}">
                                    <td class="health_care_list @if($key==0) active @endif" health_care_id="{{$healthCare->id??''}}">{{$healthCare->name??''}}, {{$healthCare->getUpazilla->name??''}}, {{$healthCare->getDistrict->name??''}}</td>
                                </tr>
                            @endforeach
                    </tbody>
                </table>
                </div>
            </div>
        </div>
    </section>
    <!-- millions smile section -->
    <section class="millions-smile-section">
        <div class="millions-smile-header">
            <div class="millions-smile-header-content">
                <h2 data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500">Specialty</h2>
                <p data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="700">To ensure comprehensive primary healthcare, our specialty lays on these specific areas, for patients to choose from</p>
            </div>
            <div class="health-left">
                <img src="/assets//healthcare/leafs/health-left-leaf.png" alt="">
            </div>
            <div class="health-right-top">
                <img src="/assets//healthcare/leafs/health-right-up-leaf.png" alt="">
            </div>
        </div>
        <div class="million-smile-body">
            <div class="smile-body-listings">
                <div class="woman-child">
                    <div class="smile-body-circle" id="smileCircle"></div>
                </div>
                <!-- smile-body-listings-left -->
                <div class="smile-body-listings-left">
                    <div class="smile-list-item smile-list-item-1" id="smileList1">
                        <!-- <p><a href="/medicine">General Medicine</a></p> -->
                        <p><a href="#">General Medicine</a></p>
                    </div>
                    <div class="smile-list-item smile-list-item-2" id="smileList2">
                        <p><a href="/gynae-and-obs">Gynae and Obs</a></p>
                    </div>
                    <div class="smile-list-item smile-list-item-3" id="smileList3">
                        <p><a href="/pediatric">Child Care</a></p>
                    </div>
                </div>
                <!-- smile-body-listings-right -->
                <div class="smile-body-listings-right">
                    <div class="smile-list-item smile-list-item-4" id="smileList4">
                        <p><a href="/eye-care">Eye Care</a></p>
                    </div>
                    <div class="smile-list-item smile-list-item-5" id="smileList5">
                        <p><a href="/ent-care">ENT Care</a></p>
                    </div>
                    <div class="smile-list-item smile-list-item-6" id="smileList6">
                        <!-- <p><a href="/diabetes">Diabetes</a></p> -->
                        <p><a href="#">Diabetes</a></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="million-smile-body-mobile">
            <div class="women-child-container">
                <div class="women-child-container-circle" id="smileCircle"></div>
            </div>
            <!-- <div class="stories-header mt-3">
                <img src="/assets/Stories.png" alt="">
            </div> -->
            <div class="stories-list">
                <ul>
                    <li data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="400" id="smileList1">Medicine</li>
                    <li data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="500" id="smileList2">Gynae and Obs</li>
                    <li data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="600" id="smileList3">Pediatric</li>
                    <li data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="800" id="smileList4">Eye Care</li>
                    <li data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="900" id="smileList5">ENT Care</li>
                    <li data-aos="fade-up" data-aos-anchor-placement="bottom-bottom" data-aos-duration="900" id="smileList6">Diabetes</li>
                </ul>
            </div>
        </div>
    </section>

    <!-- stories -->
    @include('frontend.partials.stories-section')

@endsection
@section('scripts')
<link rel="stylesheet" href="/css/scss/healthcare.css">

<script src="https://cdn.jsdelivr.net/gh/dixonandmoe/rellax@master/rellax.min.js"></script>
<script src="https://unpkg.com/aos@next/dist/aos.js"></script>
<!-- <script src="/js/index.js"></script> -->
<script src="/js/health-image-hover.js"></script>
<!-- <script src="/js/dropdown.js"></script> -->
<script>
$(document).on('click', 'tr.health_care_list_tr', function(){
        $(".health_care_list_tr").removeClass('active');
        var healthCareID=$(this).attr('health_care_id');
        $(this).addClass('active');
        getHealthCenterByID(healthCareID);
});

$('#search_by_location').on('input', function() {
        var q=$('#search_by_location').val();
        if(q.length>2){
            $.ajax({
                url: "/get-health-center-by-value",
                type: "get", //send it through get method
                data: {
                    search: q
                },
                success: function(response) {
                    $('#health_center_list_table').html('');
                    $('#health_center_list_table').html(response);
                    // $('#address').html(response.address);
                    // $('#district_name').html(response.get_district.name);
                    // $('#upazilla_name').html(response.get_upazilla.name);
                    // $('#contact_info').html(response.contact_info);
                    // $('#health_center_banner_image').attr('src',response.banner_image);
                },
                error: function(xhr) {
                    console.log(xhr);
                }
            });
        }
});


    function getHealthCenterByID(healthCareID=''){
        $.ajax({
        url: "/get-health-center-by-id",
        type: "get", //send it through get method
        data: {
            healthCareID: healthCareID
        },
        success: function(response) {
            $('#health_center_name').html(response.name);
            $('#address').html(response.address);
            $('#district_name').html(response.get_district.name);
            $('#upazilla_name').html(response.get_upazilla.name);
            $('#contact_info').html(response.contact_info);
            $('#health_center_banner_image').attr('src',response.banner_image);
        },
        error: function(xhr) {
            console.log(xhr);
        }
      });
};


    $('#division_id').change(function(){
        getDistrictByDivision();
    });

    $('#district_id').change(function(){
    var district_id = $('#district_id').val();
        getUpazillaByDistrict('', district_id);
    });

function getDistrictByDivision(district=''){
    var division_id = $('#division_id').val();
        $.ajax({
        url: "/get-district",
        type: "get", //send it through get method
        data: {
            division: division_id,
            district:district
        },
        success: function(response) {
            $('#district_id').html(response);
        },
        error: function(xhr) {
            console.log(xhr);
        }
      });
};
function getUpazillaByDistrict(upazilla='',district=''){
        $.ajax({
        url: "/get-upazilla",
        type: "get", //send it through get method
        data: {
            district: district,
            upazilla:upazilla
        },
        success: function(response) {
            $('#upazilla_id').html(response);
        },
        error: function(xhr) {
            console.log(xhr);
        }
    });
}

$(document).ready(function(){
    var district=$('#district_id').attr('district_id');
    var upazilla=$('#upazilla_id').attr('upazilla_id');
    getDistrictByDivision(district);
    getUpazillaByDistrict(upazilla,district);

    $('#Path_431').click(function(){
        getHealthCenterByDivision(30);
        $('#Path_431').addClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').removeClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').removeClass('active');
    });

    $('#Path_420').click(function(){
        getHealthCenterByDivision(20);
        $('#Path_431').removeClass('active');
        $('#Path_420').addClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').removeClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').removeClass('active');
    });
    $('#Path_424').click(function(){
        getHealthCenterByDivision(40);
        $('#Path_431').removeClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').addClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').removeClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').removeClass('active');
    });
    $('#Path_426').click(function(){
        getHealthCenterByDivision(10);
        $('#Path_431').removeClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').addClass('active');

        $('#Path_422').removeClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').removeClass('active');
    });
    $('#Path_422').click(function(){
        getHealthCenterByDivision(50);
        $('#Path_431').removeClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').addClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').removeClass('active');
    });
    $('#Path_423').click(function(){
        getHealthCenterByDivision(55);
        $('#Path_431').removeClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').removeClass('active');
        $('#Path_423').addClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').removeClass('active');
    });
    $('#Path_441').click(function(){
        getHealthCenterByDivision(60);
        $('#Path_431').removeClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').removeClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').addClass('active');
        $('#Path_440').removeClass('active');
    });

    $('#Path_440').click(function(){
        getHealthCenterByDivision(35);
        $('#Path_431').removeClass('active');
        $('#Path_420').removeClass('active');
        $('#Path_424').removeClass('active');
        $('#Path_426').removeClass('active');
        $('#Path_422').removeClass('active');
        $('#Path_423').removeClass('active');
        $('#Path_441').removeClass('active');
        $('#Path_440').addClass('active');
    });


});
function getHealthCenterByDivision(divisionID){
    $.ajax({
                url: "/get-health-center-by-division",
                type: "get", //send it through get method
                data: {
                    divisionID: divisionID
                },
                success: function(response) {
                    $('.division_name').html(response[0].division_name);
                    $('#health_center_name').html(response[0].health_center_name);
                    $('#health_center_banner_image').attr('src',response[0].banner_image);
                    $('#contact_info').html(response[0].contact_info);
                    // $('#health_center_list_table').html('');
                    // $('#health_center_list_table').html(response);
                    $('#address').html(response[0].address);
                    $('#district_name').html(response[0].district_name);
                    $('#upazilla_name').html(response[0].upazilla_name);
                    // $('#contact_info').html(response.contact_info);
                    // $('#health_center_banner_image').attr('src',response.banner_image);
                    $('#health_center_list_table').html('');
                    $('#health_center_list_table').html(response[1]);
                },
                error: function(xhr) {
                    console.log(xhr);
                }
            });
}
</script>
@endsection

